/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package csc212hw08;

import java.io.FileNotFoundException;
import java.util.Scanner;

/**
 *
 * @author William
 */
public class Main {

    /**
     * @param args the command line arguments
     * @throws java.io.FileNotFoundException
     */
    public static void main(String[] args) throws FileNotFoundException {
        // Create a Scanner for keyboard input
        Scanner kb = new Scanner(System.in);
        // User's command
        String command;

        // Create and load the CDDB object from the input file
        CDDB db = new CDDB();
        db.load("cds.txt");
        System.out.println("Welcome to the CD Database");
        // Ask for and process user commands
        do {
            // Prompt for command
            System.out.println("Enter search, add, name, list, or quit:");
            command = kb.nextLine();

            // Process request
            switch (command) {
                case "search":
                    // get UPC from user
                    System.out.println("Enter the UPC:");
                    String upc = kb.nextLine();
                    String cdInfo = db.getCD(upc);
                    if (cdInfo != null) {
                        System.out.println(cdInfo);
                    } else {
                        System.out.println("CD not found");
                    }
                    break;
                case "add":
                    System.out.println("Enter the UPC:");
                    String u = kb.nextLine();
                    System.out.println("Enter the price:");
                    double p = kb.nextDouble();
                    kb.nextLine();
                    System.out.println("Enter the Artist:");
                    String a = kb.nextLine();
                    System.out.println("Enter the Title:");
                    String t = kb.nextLine();

                    db.addCD(u, p, a, t);
                    System.out.println("Add complete.");
                    break;
                case "name":
                    System.out.println("Enter the full or partial name:");
                    String name = kb.nextLine();
                    db.printByName(name);
                    break;
                case "list":
                    db.printAll();
                    break;
                case "quit":
                    System.out.println("Program ending.");
                    break;
                default:
                    System.out.println("I don't understand your command. Please try again.");
                    break;
            }
        } while (!command.equals("quit"));
    }
}
