/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package csc212hw08;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.*;

/**
 *
 * @author William
 */
public class CDDB {

    private HashMap<String, CompactDisc> database;

    public CDDB() {
        database = new HashMap<String, CompactDisc>();
    }

    public void load(String fn) throws FileNotFoundException {
        File f = new File(fn);
        Scanner sc = new Scanner(f);

        while (sc.hasNextLine()) {
            // Create a Scanner from the input line
            Scanner lineScanner = new Scanner(sc.nextLine());
            // Change the delimiter to a comma
            lineScanner.useDelimiter(",");
            // Create a CompactDisc object from the tokens
            CompactDisc cd = new CompactDisc(lineScanner.next(), lineScanner.nextDouble(), lineScanner.next(), lineScanner.next());
            // Add the missing statement
            database.put(cd.getUPC(), cd);
        }
    }

    public void addCD(String u, double p, String a, String t) {
        CompactDisc cd = new CompactDisc(u, p, a, t);
        database.put(cd.getUPC(), cd);
    }

    public String getCD(String key) {
        if (database.containsKey(key)) {
            // Key was found -- get the value
            return database.get(key).toString();
        } else {
            // Key was not found
            return null;
        }
    }

    public void printByName(String name) {
        int count = 0;
        for (CompactDisc value: database.values()) {
            if (value.getArtist().contains(name)) {
                count = 1;
                
                // match found 
                System.out.println(value.toString());
            }                
        }
        if (count== 0){
            System.out.println("No CDs found for " + name);
        }
    }

    public void printAll() {
        for (CompactDisc values: database.values()) {
            System.out.println(values);
        }

    }
}
