/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package csc212lab09;

import java.util.Random;

/**
 *
 * @author William
 */
public class VendingMachine {

    int shelves;
    int slotsPerShelf;
    Candy slots[][];

    public VendingMachine(int sh, int sl) {
        shelves = sh;
        slotsPerShelf = sl;
        slots = new Candy[shelves][slotsPerShelf];
    }

    public void load(String[] names) {
        // Random object for choosing name, price, and size
        Random r = new Random();

        // Iterate over shelves
        for (int i = 0; i < shelves; i++) {

            // Iterate over slots in a shelf
            for (int j = 0; j < slotsPerShelf; j++) {
                // Use a random index to get a candy name
                String index = names[r.nextInt(10)];
                // then geenrate a random price and number of ounces
                float price = r.nextFloat();
                int ounces = r.nextInt(4) + 1;
                // Generate random values and create a new Candy object
                slots[i][j] = new Candy(index, price, ounces);
            }
        }
    }

    public void display() {
        // Display the column labels
        System.out.print(" ");
        for (int j = 0; j < slots[0].length; j++) {
            System.out.printf("|%25d|", j);
        }
        System.out.println();
        // Display the contents of the machine
        for (int i = 0; i < shelves; i++) {
            // Display the row label
            System.out.printf("%2d", i);
            for (int j = 0; j < slotsPerShelf; j++) {
                if (slots[i][j] == null) {
                    // slot is empty
                    System.out.printf("|%25s|", "");
                } else {
                    System.out.printf("|%25s|", slots[i][j].getName());
                }
            }
            System.out.println();
        }
        System.out.println();
    }

    public void purchase(int r, int s) {
        // Attempt to purchase the item in row r, slot s
        if (r >= shelves || r < 0  || s >= slotsPerShelf || s < 0) {
            System.out.println("Invalid selection");
        } else {
            System.out.println("You purchased: " + slots[r][s]);
            slots[r][s]= null;
        }
    }
}